﻿using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Linq;

public class PatientImageDetailRepository
{
    private const string CONNECT_STRING_NAME = "RegistryConnectionString";

    private const string SP_GET_PATIENT_IMAGE_DETAIL = "[EFR].[usp_GetPatientImageDetail]";
    private const string SP_GET_PATIENT_IMAGE_BODY_PARTS = "[EFR].[usp_GetPatientImageBodyParts]";
    private const string SP_GET_PATIENT_IMAGE_TYPES = "[EFR].[usp_GetPatientImageTypes]";
    private const string SP_GET_PATIENT_IMAGING_REASONS = "[EFR].[usp_GetPatientImagingReasons]";

    private const string SP_GET_STD_IMAGE_BODY_PARTS = "[EFR].[usp_GetStandardImageBodyParts]";
    private const string SP_GET_STD_IMAGE_FRAGMENT_COUNT = "[EFR].[usp_GetStandardFragmentCount]";
    private const string SP_GET_STD_IMAGE_REASONS = "[EFR].[usp_GetStandardImageReasons]";
    private const string SP_GET_STD_IMAGE_TYPES = "[EFR].[usp_GetStandardImageTypes]";

    private const string SP_REVERT_PATIENT_IMAGE = "[EFR].[usp_RevertPatientImage]";
    private const string SP_UPDATE_PATIENT_IMAGE = "[EFR].[usp_UpdatePatientImage]";

    internal static IEnumerable<string> LoadReferenceImageBodyParts()
    {
        return ImagingDataRepository.LoadReferenceValuesDescription(SP_GET_STD_IMAGE_BODY_PARTS);
    }

    internal static IEnumerable<string> LoadReferenceImageFragmentCounts()
    {
        return ImagingDataRepository.LoadReferenceValuesDescription(SP_GET_STD_IMAGE_FRAGMENT_COUNT, "(Select a Value)");
    }

    internal static IEnumerable<string> LoadReferenceImageReasons()
    {
        return ImagingDataRepository.LoadReferenceValuesDescription(SP_GET_STD_IMAGE_REASONS);
    }

    internal static IEnumerable<string> LoadReferenceImageTypes()
    {
        return ImagingDataRepository.LoadReferenceValuesDescription(SP_GET_STD_IMAGE_TYPES);
    }

    internal PatientImageDetail GetPatientImageDetails(int patientImageId)
    {
        using (var patientImageTable = SqlProvider.ExecuteSPDataTable(
                CONNECT_STRING_NAME,
                SP_GET_PATIENT_IMAGE_DETAIL,
                new[] { string.Format("{0}", patientImageId) }))
        {
            if (patientImageTable != null && patientImageTable.Rows != null && patientImageTable.Rows.Count > 0)
                return new PatientImageDetail(patientImageTable.Rows[0]);
        }

        return null;
    }

    internal void UpdatePatientImageTable(object[] parameters, IReadOnlyList<int> imageBodyParts, IReadOnlyList<int> imagingReasons)
    {
        var connectionString = ConfigurationManager.ConnectionStrings[CONNECT_STRING_NAME].ConnectionString;

        using (SqlConnection connection = new SqlConnection(connectionString))
        using (SqlCommand updateCommand = new SqlCommand(SP_UPDATE_PATIENT_IMAGE, connection))
        {
            connection.Open();

            updateCommand.CommandType = CommandType.StoredProcedure;

            updateCommand.Parameters.AddWithValue("@Study", parameters[0]);
            updateCommand.Parameters.AddWithValue("@StdImageFragmentCountId", parameters[1]);
            updateCommand.Parameters.AddWithValue("@StdImageTypeId", parameters[2]);
            updateCommand.Parameters.AddWithValue("@FragmentVerifiedFlag", parameters[3]);
            updateCommand.Parameters.AddWithValue("@ReviewedFlag", parameters[4]);
            updateCommand.Parameters.AddWithValue("@IncludeInReportFlag", parameters[5]);
            updateCommand.Parameters.AddWithValue("@LargestFragmentLength", parameters[6]);
            updateCommand.Parameters.AddWithValue("@LargestFragmentWidth", parameters[7]);
            updateCommand.Parameters.AddWithValue("@SmallestFragmentLength", parameters[8]);
            updateCommand.Parameters.AddWithValue("@SmallestFragmentWidth", parameters[9]);
            updateCommand.Parameters.AddWithValue("@Comments", parameters[10]);
            updateCommand.Parameters.AddWithValue("@ImageReasonOtherText", parameters[11]);
            updateCommand.Parameters.AddWithValue("@ImageTypeOtherText", parameters[12]);
            updateCommand.Parameters.AddWithValue("@User", parameters[13]);

            if (imageBodyParts != null && imageBodyParts.Any())
            {
                SqlParameter tvpImageBodyParts = updateCommand.Parameters.AddWithValue("@ImageBodyParts", GetParameterTable(imageBodyParts));
                tvpImageBodyParts.SqlDbType = SqlDbType.Structured;
            }

            if (imagingReasons != null && imagingReasons.Any())
            {
                SqlParameter tvpReasons = updateCommand.Parameters.AddWithValue("@ImageReasons", GetParameterTable(imagingReasons));
                tvpReasons.SqlDbType = SqlDbType.Structured;
            }

            updateCommand.ExecuteNonQuery();
        }
    }

    private DataTable GetParameterTable(IReadOnlyList<int> collection)
    {
        var parameters = new DataTable();
        parameters.Columns.Add("id", typeof(int));

        foreach (var id in collection)
        {
            DataRow row = parameters.Rows.Add();
            row.SetField("id", id + 1);
        }

        return parameters;
    }

    internal PatientImageMap[] GetImageBodyParts(int patientImageId)
    {
        return GetImageMap(patientImageId, SP_GET_PATIENT_IMAGE_BODY_PARTS);
    }

    internal PatientImageMap[] GetImageReasons(int patientImageId)
    {
        return GetImageMap(patientImageId, SP_GET_PATIENT_IMAGING_REASONS);
    }

    internal PatientImageMap GetImageType(int patientImageId)
    {
        var map = GetImageMap(patientImageId, SP_GET_PATIENT_IMAGE_TYPES);

        if (map.Any())

            return map.Single();
        return null;
    }

    internal PatientImageMap GetFragmentCount(int patientImageId)
    {
        var map = GetImageMap(patientImageId, SP_GET_PATIENT_IMAGE_TYPES);

        if (map.Any())

            return map.Single();
        return null;
    }

    internal PatientImageMap[] GetImageMap(int patientImageId, string sproc)
    {
        List<PatientImageMap> map = new List<PatientImageMap>();

        using (var patientImageTable = SqlProvider.ExecuteSPDataTable(
                            CONNECT_STRING_NAME,
                            sproc,
                            new[] { string.Format("{0}", patientImageId) }))
        {
            if (patientImageTable != null && patientImageTable.Rows != null && patientImageTable.Rows.Count > 0)
            {
                foreach (DataRow row in patientImageTable.Rows)
                    map.Add(new PatientImageMap(row));
            }
        }

        return map.ToArray();
    }
}